/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.create;

import com.newrelic.agent.Agent;
import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.create.JmxConfiguration;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JmxYmlParser
implements JmxConfiguration {
    private static final String YML_PROP_OBJECT_NAME = "object_name";
    private static final String YML_PROP_ROOT_METRIC_NAME = "root_metric_name";
    private static final String YML_PROP_ENABLED = "enabled";
    private static final String YML_PROP_METRICS = "metrics";
    private static final String YML_PROP_ATTRS = "attributes";
    private static final String YML_PROP_ATT = "attribute";
    private static final String YML_PROP_TYPE = "type";
    private final Map<?, ?> jmxConfig;

    public JmxYmlParser(Map<?, ?> pJmxConfig) {
        this.jmxConfig = pJmxConfig;
    }

    @Override
    public String getObjectName() {
        return (String)this.jmxConfig.get(YML_PROP_OBJECT_NAME);
    }

    @Override
    public String getRootMetricName() {
        return (String)this.jmxConfig.get(YML_PROP_ROOT_METRIC_NAME);
    }

    @Override
    public boolean getEnabled() {
        Boolean isEnabled = (Boolean)this.jmxConfig.get(YML_PROP_ENABLED);
        return isEnabled == null || isEnabled != false;
    }

    @Override
    public Map<JmxType, List<String>> getAttrs() {
        Object metrics = this.jmxConfig.get(YML_PROP_METRICS);
        if (metrics == null) {
            Agent.LOG.log(Level.WARNING, "There is no 'metric' property in the JMX configuration file. Please verify the format of your yml file.");
            return null;
        }
        if (!(metrics instanceof List)) {
            Agent.LOG.log(Level.WARNING, "The 'metric' property in the JMX configuration file is incorrect. Please verify the format of your yml file.");
            return null;
        }
        HashMap<JmxType, List<String>> attrs = new HashMap<JmxType, List<String>>(3);
        for (Map metric : (List)metrics) {
            JmxType type = JmxYmlParser.findType(metric);
            List<String> attList = JmxYmlParser.findAttributes(metric);
            if (attList.size() <= 0) continue;
            List alreadyAdded = (List)attrs.get((Object)type);
            if (alreadyAdded == null) {
                attrs.put(type, attList);
                continue;
            }
            alreadyAdded.addAll(attList);
        }
        return attrs;
    }

    private static JmxType findType(Map<?, ?> metricMap) {
        String type = (String)metricMap.get(YML_PROP_TYPE);
        if (type == null || type.equals(JmxType.MONOTONICALLY_INCREASING.getYmlName())) {
            return JmxType.MONOTONICALLY_INCREASING;
        }
        if (type.equals(JmxType.SIMPLE.getYmlName())) {
            return JmxType.SIMPLE;
        }
        String msg = MessageFormat.format("Unknown JMX metric type: {0}.  Using default type: {1}", new Object[]{type, JmxType.MONOTONICALLY_INCREASING});
        Agent.LOG.warning(msg);
        return JmxType.MONOTONICALLY_INCREASING;
    }

    private static List<String> findAttributes(Map<?, ?> metricMap) {
        ArrayList<String> result = new ArrayList<String>();
        String attributes = (String)metricMap.get(YML_PROP_ATTRS);
        if (attributes != null) {
            for (String attribute : attributes.split(",")) {
                String current = attribute.trim();
                if (current.length() == 0) continue;
                result.add(current);
            }
        } else {
            String attribute = (String)metricMap.get(YML_PROP_ATT);
            if (attribute != null && attribute.trim().length() > 0) {
                result.add(attribute.trim());
            }
        }
        return result;
    }
}

