/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class ManyClassMatcher
extends ClassMatcher {
    private final ClassMatcher[] matchers;
    private final boolean isExact;

    public ManyClassMatcher(Collection<ClassMatcher> matchers) {
        this.matchers = matchers.toArray(new ClassMatcher[matchers.size()]);
        this.isExact = ManyClassMatcher.determineIfExact(this.matchers);
    }

    private static boolean determineIfExact(ClassMatcher[] matchers) {
        for (ClassMatcher matcher : matchers) {
            if (matcher.isExactClassMatcher()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isExactClassMatcher() {
        return this.isExact;
    }

    protected ClassMatcher[] getClassMatchers() {
        return this.matchers;
    }

    @Override
    public Collection<String> getClassNames() {
        ArrayList<String> classNames = new ArrayList<String>();
        for (ClassMatcher matcher : this.matchers) {
            classNames.addAll(matcher.getClassNames());
        }
        return classNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.matchers);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManyClassMatcher other = (ManyClassMatcher)obj;
        return Arrays.equals(this.matchers, other.matchers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.matchers + ")";
    }
}

