/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.heap;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.JavaVersionUtils;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ClassHistogramHelper {
    private static final String WINDOWS_DIR_COMMAND = "cmd.exe /c dir /-n ";
    private static final Pattern JAVA_AGENT_CLASS = Pattern.compile("^(\\[*L?com.(nr|newrelic).(agent|api.agent|weave|bootstrap|org.apache)).*");
    private static final Pattern ROW_SPLITTER = Pattern.compile("\\s+");
    private static final Set<String> HOTSPOT = Sets.newHashSet("<constantPoolKlass>", "<constantPoolCacheKlass>", "<methodKlass>", "<methodDataKlass>", "<constMethodKlass>", "<instanceKlass>", "<instanceKlassKlass>");
    private static final Set<String> BASIC = Sets.newHashSet("java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Character");
    private static final Set<String> ARRAY_BASIC = Sets.newHashSet("[Ljava.lang.Boolean", "[Ljava.lang.Byte", "[Ljava.lang.Short", "[Ljava.lang.Integer", "[Ljava.lang.Long", "[Ljava.lang.Float", "[Ljava.lang.Double", "[Ljava.lang.Character");
    private static final Set<String> ARRAY_PRIMITIVE = Sets.newHashSet("[Z", "[B", "[S", "[I", "[J", "[F", "[D", "[C");

    private static ClassType getType(String className) {
        if (className.startsWith("[[")) {
            className = className.replaceAll("\\[+", "[");
        }
        if (BASIC.contains(className)) {
            return ClassType.BASIC;
        }
        if (ARRAY_BASIC.contains(className)) {
            return ClassType.ARRAY_BASIC;
        }
        if (ARRAY_PRIMITIVE.contains(className)) {
            return ClassType.ARRAY_PRIMITIVE;
        }
        if (className.startsWith("[L")) {
            return ClassType.ARRAY_CLASS;
        }
        if (HOTSPOT.contains(className)) {
            return ClassType.HOTSPOT;
        }
        return ClassType.CLASS;
    }

    public static String[] split(String row) {
        return ROW_SPLITTER.split(row);
    }

    public static String getClassLabel(String className) {
        return ClassHistogramHelper.getType(className).typeName;
    }

    public static boolean isNewRelicJavaAgentClass(String className) {
        return JAVA_AGENT_CLASS.matcher(className).matches();
    }

    public static boolean isWindows() {
        String os = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase();
        return os.startsWith("windows");
    }

    public static boolean jmapExists(String jmapPath) {
        if (JavaVersionUtils.isJavaSpecVersionGreaterThanOrEqualTo("1.7")) {
            if (ClassHistogramHelper.isWindows()) {
                List<String> stdout = ClassHistogramHelper.runSysCommand(WINDOWS_DIR_COMMAND + ClassHistogramHelper.addQuotes(jmapPath));
                if (stdout != null) {
                    for (String dir : stdout) {
                        if (!dir.startsWith("jmap ")) continue;
                        return true;
                    }
                }
            } else {
                List<String> stdout = ClassHistogramHelper.runSysCommand("ls " + jmapPath);
                if (stdout != null && stdout.contains("jmap")) {
                    return true;
                }
            }
            Agent.LOG.log(Level.INFO, "Class Histogram Service couldn't find jmap");
        } else {
            Agent.LOG.log(Level.INFO, "Class Histogram Service requires Java 7 or greater and the jmap executable. Service will be disabled.");
        }
        return false;
    }

    private static String addQuotes(String ... parts) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        for (String part : parts) {
            builder.append(part);
        }
        builder.append("\"");
        return builder.toString();
    }

    public static List<String> runJmapCommand(String jmapPath, int pid) {
        if (ClassHistogramHelper.isWindows()) {
            return ClassHistogramHelper.runSysCommand(ClassHistogramHelper.addQuotes(jmapPath, "jmap") + " -histo " + pid);
        }
        return ClassHistogramHelper.runSysCommand(jmapPath + "jmap -histo " + pid);
    }

    private static List<String> runSysCommand(String command) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            StreamEater stderr = new StreamEater(p.getErrorStream());
            stderr.start();
            StreamEater stdout = new StreamEater(p.getInputStream());
            stdout.start();
            int exitValue = p.waitFor();
            stderr.join();
            stdout.join();
            if (exitValue == 0) {
                return stdout.getOutput();
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, t, "Couldn't read value of system command: " + command);
        }
        return null;
    }

    private static class StreamEater
    extends Thread {
        final InputStream is;
        final List<String> output;

        public StreamEater(InputStream is) {
            this.is = is;
            this.output = new LinkedList<String>();
        }

        public List<String> getOutput() {
            return this.output;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.output.add(line);
                }
                br.close();
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINER, e, "Exception reading output stream");
            }
        }
    }

    private static enum ClassType {
        HOTSPOT("hotspot"),
        BASIC("basic"),
        ARRAY_BASIC("array_basic"),
        ARRAY_PRIMITIVE("array_primitive"),
        CLASS("class"),
        ARRAY_CLASS("array_class");

        private final String typeName;

        private ClassType(String typeName) {
            this.typeName = typeName;
        }
    }
}

