/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex;

import com.newrelic.agent.deps.jregex.BackReference;
import com.newrelic.agent.deps.jregex.Branch;
import com.newrelic.agent.deps.jregex.CharacterClass;
import com.newrelic.agent.deps.jregex.ConditionalExpr;
import com.newrelic.agent.deps.jregex.Group;
import com.newrelic.agent.deps.jregex.IndependentGroup;
import com.newrelic.agent.deps.jregex.Iterator;
import com.newrelic.agent.deps.jregex.Lookahead;
import com.newrelic.agent.deps.jregex.Lookbehind;
import com.newrelic.agent.deps.jregex.Optimizer;
import com.newrelic.agent.deps.jregex.Pattern;
import com.newrelic.agent.deps.jregex.PatternSyntaxException;
import com.newrelic.agent.deps.jregex.Pretokenizer;
import com.newrelic.agent.deps.jregex.REFlags;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Term
implements REFlags {
    static final int CHAR = 0;
    static final int BITSET = 1;
    static final int BITSET2 = 2;
    static final int ANY_CHAR = 4;
    static final int ANY_CHAR_NE = 5;
    static final int REG = 6;
    static final int REG_I = 7;
    static final int FIND = 8;
    static final int FINDREG = 9;
    static final int SUCCESS = 10;
    static final int BOUNDARY = 11;
    static final int DIRECTION = 12;
    static final int UBOUNDARY = 13;
    static final int UDIRECTION = 14;
    static final int GROUP_IN = 15;
    static final int GROUP_OUT = 16;
    static final int VOID = 17;
    static final int START = 18;
    static final int END = 19;
    static final int END_EOL = 20;
    static final int LINE_START = 21;
    static final int LINE_END = 22;
    static final int LAST_MATCH_END = 23;
    static final int CNT_SET_0 = 24;
    static final int CNT_INC = 25;
    static final int CNT_GT_EQ = 26;
    static final int READ_CNT_LT = 27;
    static final int CRSTORE_CRINC = 28;
    static final int CR_SET_0 = 29;
    static final int CR_LT = 30;
    static final int CR_GT_EQ = 31;
    static final int BRANCH = 32;
    static final int BRANCH_STORE_CNT = 33;
    static final int BRANCH_STORE_CNT_AUX1 = 34;
    static final int PLOOKAHEAD_IN = 35;
    static final int PLOOKAHEAD_OUT = 36;
    static final int NLOOKAHEAD_IN = 37;
    static final int NLOOKAHEAD_OUT = 38;
    static final int PLOOKBEHIND_IN = 39;
    static final int PLOOKBEHIND_OUT = 40;
    static final int NLOOKBEHIND_IN = 41;
    static final int NLOOKBEHIND_OUT = 42;
    static final int INDEPENDENT_IN = 43;
    static final int INDEPENDENT_OUT = 44;
    static final int REPEAT_0_INF = 45;
    static final int REPEAT_MIN_INF = 46;
    static final int REPEAT_MIN_MAX = 47;
    static final int REPEAT_REG_MIN_INF = 48;
    static final int REPEAT_REG_MIN_MAX = 49;
    static final int BACKTRACK_0 = 50;
    static final int BACKTRACK_MIN = 51;
    static final int BACKTRACK_FIND_MIN = 52;
    static final int BACKTRACK_FINDREG_MIN = 53;
    static final int BACKTRACK_REG_MIN = 54;
    static final int MEMREG_CONDITION = 55;
    static final int LOOKAHEAD_CONDITION_IN = 56;
    static final int LOOKAHEAD_CONDITION_OUT = 57;
    static final int LOOKBEHIND_CONDITION_IN = 58;
    static final int LOOKBEHIND_CONDITION_OUT = 59;
    static final int FIRST_TRANSPARENT = 11;
    static final int LAST_TRANSPARENT = 31;
    static final int VARS_LENGTH = 4;
    private static final int MEMREG_COUNT = 0;
    private static final int CNTREG_COUNT = 1;
    private static final int DEPTH = 2;
    private static final int LOOKAHEAD_COUNT = 3;
    private static final int LIMITS_LENGTH = 3;
    private static final int LIMITS_PARSE_RESULT_INDEX = 2;
    private static final int LIMITS_OK = 1;
    private static final int LIMITS_FAILURE = 2;
    Term next;
    Term failNext;
    int type = 17;
    boolean inverse;
    char c;
    int distance;
    boolean eat;
    boolean[] bitset;
    boolean[][] bitset2;
    boolean[] categoryBitset;
    char[] brackets;
    int weight;
    int memreg = -1;
    int minCount;
    int maxCount;
    Term target;
    int cntreg = 0;
    int lookaheadId;
    protected Term prev;
    protected Term in;
    protected Term out;
    protected Term out1;
    protected Term first;
    protected Term current;
    protected Term branchOut;
    static int instances;
    int instanceNum = instances++;

    Term() {
        this.in = this.out = this;
    }

    Term(int type) {
        this();
        this.type = type;
    }

    static void makeTree(String s, int flags, Pattern re) throws PatternSyntaxException {
        char[] data = s.toCharArray();
        Term.makeTree(data, 0, data.length, flags, re);
    }

    static void makeTree(char[] data, int offset, int end, int flags, Pattern re) throws PatternSyntaxException {
        Term first;
        int[] vars = new int[]{1, 0, 0, 0};
        Vector iterators = new Vector();
        Hashtable groupNames = new Hashtable();
        Pretokenizer t = new Pretokenizer(data, offset, end);
        Term term = Term.makeTree(t, data, vars, flags, new Group(), iterators, groupNames);
        term.out.type = 10;
        Term optimized = first = term.next;
        Optimizer opt = Optimizer.find(first);
        if (opt != null) {
            optimized = opt.makeFirst(first);
        }
        Enumeration en = iterators.elements();
        while (en.hasMoreElements()) {
            Iterator i = (Iterator)en.nextElement();
            i.optimize();
        }
        re.root = optimized;
        re.root0 = first;
        re.memregs = vars[0];
        re.counters = vars[1];
        re.lookaheads = vars[3];
        re.namedGroupMap = groupNames;
    }

    /*
     * Unable to fully structure code
     */
    private static Term makeTree(Pretokenizer t, char[] data, int[] vars, int flags, Term term, Vector iterators, Hashtable groupNames) throws PatternSyntaxException {
        if (vars.length != 4) {
            throw new IllegalArgumentException("vars.length should be 4, not " + vars.length);
        }
        block26: while (true) {
            t.next();
            term.append(t.tOffset, t.tOutside, data, vars, flags, iterators, groupNames);
            switch (t.ttype) {
                case 11: {
                    flags = t.flags(flags);
                    continue block26;
                }
                case 12: {
                    t.next();
                    clg = new Term();
                    CharacterClass.parseGroup(data, t.tOffset, t.tOutside, clg, (flags & 1) > 0, (flags & 8) > 0, (flags & 16) > 0, (flags & 32) > 0);
                    term.append(clg);
                    continue block26;
                }
                case 3: {
                    vars[2] = vars[2] + 1;
                    term.append(Term.makeTree(t, data, vars, t.flags(flags), new Group(), iterators, groupNames));
                    continue block26;
                }
                case 13: {
                    gname = t.groupName;
                    if (Character.isDigit(gname.charAt(0))) {
                        try {
                            id = Integer.parseInt(gname);
                        }
                        catch (NumberFormatException e) {
                            throw new PatternSyntaxException("group name starts with digit but is not a number");
                        }
                        if (groupNames.contains(new Integer(id)) && t.groupDeclared) {
                            throw new PatternSyntaxException("group redeclaration: " + gname + "; use ({=id}...) for multiple group assignments");
                        }
                        if (vars[0] <= id) {
                            vars[0] = id + 1;
                        }
                    } else {
                        no = (Integer)groupNames.get(gname);
                        if (no == null) {
                            vars[0] = vars[0] + 1;
                            groupNames.put(t.groupName, new Integer(id));
                        } else {
                            if (t.groupDeclared) {
                                throw new PatternSyntaxException("group redeclaration " + gname + "; use ({=name}...) for group reassignments");
                            }
                            id = no;
                        }
                    }
                    vars[2] = vars[2] + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Group(id), iterators, groupNames));
                    continue block26;
                }
                case 40: {
                    vars[2] = vars[2] + 1;
                    v0 = vars[0];
                    vars[0] = v0 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Group(v0), iterators, groupNames));
                    continue block26;
                }
                case 4: {
                    vars[2] = vars[2] + 1;
                    v1 = vars[3];
                    vars[3] = v1 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookahead(v1, true), iterators, groupNames));
                    continue block26;
                }
                case 5: {
                    vars[2] = vars[2] + 1;
                    v2 = vars[3];
                    vars[3] = v2 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookahead(v2, false), iterators, groupNames));
                    continue block26;
                }
                case 6: {
                    vars[2] = vars[2] + 1;
                    v3 = vars[3];
                    vars[3] = v3 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookbehind(v3, true), iterators, groupNames));
                    continue block26;
                }
                case 7: {
                    vars[2] = vars[2] + 1;
                    v4 = vars[3];
                    vars[3] = v4 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookbehind(v4, false), iterators, groupNames));
                    continue block26;
                }
                case 8: {
                    vars[2] = vars[2] + 1;
                    v5 = vars[3];
                    vars[3] = v5 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new IndependentGroup(v5), iterators, groupNames));
                    continue block26;
                }
                case 10: {
                    vars[2] = vars[2] + 1;
                    t.next();
                    fork = null;
                    positive = true;
                    switch (t.ttype) {
                        case 5: {
                            positive = false;
                        }
                        case 4: {
                            vars[2] = vars[2] + 1;
                            v6 = vars[3];
                            vars[3] = v6 + 1;
                            la = new Lookahead(v6, positive);
                            Term.makeTree(t, data, vars, flags, la, iterators, groupNames);
                            fork = new ConditionalExpr(la);
                            break;
                        }
                        case 7: {
                            positive = false;
                        }
                        case 6: {
                            vars[2] = vars[2] + 1;
                            v7 = vars[3];
                            vars[3] = v7 + 1;
                            lb = new Lookbehind(v7, positive);
                            Term.makeTree(t, data, vars, flags, lb, iterators, groupNames);
                            fork = new ConditionalExpr(lb);
                            break;
                        }
                        case 40: {
                            t.next();
                            if (t.ttype != 41) {
                                throw new PatternSyntaxException("malformed condition");
                            }
                            if (Character.isDigit(data[t.tOffset])) {
                                memregNo = Term.makeNumber(t.tOffset, t.tOutside, data);
                            } else {
                                gn = new String(data, t.tOffset, t.tOutside - t.tOffset);
                                gno = (Integer)groupNames.get(gn);
                                if (gno == null) {
                                    throw new PatternSyntaxException("unknown group name in conditional expr.: " + gn);
                                }
                                memregNo = gno;
                            }
                            fork = new ConditionalExpr(memregNo);
                            break;
                        }
                        default: {
                            throw new PatternSyntaxException("malformed conditional expression: " + t.ttype + " '" + (char)t.ttype + "'");
                        }
                    }
                    term.append(Term.makeTree(t, data, vars, flags, fork, iterators, groupNames));
                    continue block26;
                }
                case 124: {
                    term.newBranch();
                    continue block26;
                }
                case 2: {
                    if (vars[2] > 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    term.close();
                    return term;
                }
                case 41: {
                    if (vars[2] <= 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    term.close();
                    vars[2] = vars[2] - 1;
                    return term;
                }
                case 9: {
                    while (true) {
                        if (t.ttype != 41) ** break;
                        continue block26;
                        t.next();
                    }
                }
            }
            break;
        }
        throw new PatternSyntaxException("unknown token type: " + t.ttype);
    }

    static int makeNumber(int off, int out, char[] data) {
        int n = 0;
        for (int i = off; i < out; ++i) {
            int d = data[i] - 48;
            if (d < 0 || d > 9) {
                return -1;
            }
            n *= 10;
            n += d;
        }
        return n;
    }

    protected void append(int offset, int end, char[] data, int[] vars, int flags, Vector iterators, Hashtable gmap) throws PatternSyntaxException {
        int[] limits = new int[3];
        int i = offset;
        Term current = this.current;
        block7: while (i < end) {
            Term tmp;
            char c = data[i];
            boolean greedy = true;
            switch (c) {
                case '*': {
                    if (current == null) {
                        throw new PatternSyntaxException("missing term before *");
                    }
                    if (++i < end && data[i] == '?') {
                        greedy ^= true;
                        ++i;
                    }
                    tmp = greedy ? Term.makeGreedyStar(vars, current, iterators) : Term.makeLazyStar(vars, current);
                    current = this.replaceCurrent(tmp);
                    continue block7;
                }
                case '+': {
                    if (current == null) {
                        throw new PatternSyntaxException("missing term before +");
                    }
                    if (++i < end && data[i] == '?') {
                        greedy ^= true;
                        ++i;
                    }
                    tmp = greedy ? Term.makeGreedyPlus(vars, current, iterators) : Term.makeLazyPlus(vars, current);
                    current = this.replaceCurrent(tmp);
                    continue block7;
                }
                case '?': {
                    if (current == null) {
                        throw new PatternSyntaxException("missing term before ?");
                    }
                    if (++i < end && data[i] == '?') {
                        greedy ^= true;
                        ++i;
                    }
                    tmp = greedy ? Term.makeGreedyQMark(vars, current) : Term.makeLazyQMark(vars, current);
                    current = this.replaceCurrent(tmp);
                    continue block7;
                }
                case '{': {
                    limits[0] = 0;
                    limits[1] = -1;
                    int le = Term.parseLimits(i + 1, end, data, limits);
                    if (limits[2] == 1) {
                        if (current == null) {
                            throw new PatternSyntaxException("missing term before {}");
                        }
                        i = le;
                        if (i < end && data[i] == '?') {
                            greedy ^= true;
                            ++i;
                        }
                        tmp = greedy ? Term.makeGreedyLimits(vars, current, limits, iterators) : Term.makeLazyLimits(vars, current, limits);
                        current = this.replaceCurrent(tmp);
                        continue block7;
                    }
                    if (data[i + 1] == '\\') {
                        int p = i + 2;
                        if (p == end) {
                            throw new PatternSyntaxException("'group_id' expected");
                        }
                        while (Character.isWhitespace(data[p])) {
                            if (++p != end) continue;
                            throw new PatternSyntaxException("'group_id' expected");
                        }
                        BackReference br = new BackReference(-1, (flags & 1) > 0);
                        i = Term.parseGroupId(data, p, end, br, gmap);
                        current = this.append(br);
                        continue block7;
                    }
                    Term t = new Term();
                    i = CharacterClass.parseName(data, i, end, t, false, (flags & 8) > 0);
                    current = this.append(t);
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if ((flags & 8) <= 0) break;
                    ++i;
                    continue block7;
                }
            }
            tmp = new Term();
            i = this.parseTerm(data, i, end, tmp, flags);
            if (tmp.type == 19 && i < end) {
                throw new PatternSyntaxException("'$' is not a last term in the group: <" + new String(data, offset, end - offset) + ">");
            }
            current = this.append(tmp);
        }
    }

    private static int parseGroupId(char[] data, int i, int end, Term term, Hashtable gmap) throws PatternSyntaxException {
        char c;
        int id;
        int nstart = i;
        if (Character.isDigit(data[i])) {
            while (Character.isDigit(data[i])) {
                if (++i != end) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            id = Term.makeNumber(nstart, i, data);
        } else {
            while (Character.isJavaIdentifierPart(data[i])) {
                if (++i != end) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            String s = new String(data, nstart, i - nstart);
            Integer no = (Integer)gmap.get(s);
            if (no == null) {
                throw new PatternSyntaxException("backreference to unknown group: " + s);
            }
            id = no;
        }
        while (Character.isWhitespace(data[i])) {
            if (++i != end) continue;
            throw new PatternSyntaxException("'}' expected");
        }
        if ((c = data[i++]) != '}') {
            throw new PatternSyntaxException("'}' expected");
        }
        term.memreg = id;
        return i;
    }

    protected Term append(Term term) throws PatternSyntaxException {
        Term current = this.current;
        if (current == null) {
            this.in.next = term;
            term.prev = this.in;
            this.current = term;
            return term;
        }
        Term.link(current, term);
        this.current = term;
        return term;
    }

    protected Term replaceCurrent(Term term) throws PatternSyntaxException {
        Term prev = this.current.prev;
        if (prev != null) {
            Term in = this.in;
            if (prev == in) {
                in.next = term.in;
                term.in.prev = in;
            } else {
                Term.link(prev, term);
            }
        }
        this.current = term;
        return term;
    }

    protected void newBranch() throws PatternSyntaxException {
        this.close();
        this.startNewBranch();
    }

    protected void close() throws PatternSyntaxException {
        Term current = this.current;
        if (current != null) {
            Term.linkd(current, this.out);
        } else {
            this.in.next = this.out;
        }
    }

    private static final void link(Term term, Term next) {
        Term.linkd(term, next.in);
        next.prev = term;
    }

    private static final void linkd(Term term, Term next) {
        Term prev_branch;
        Term prev_out1;
        Term prev_out = term.out;
        if (prev_out != null) {
            prev_out.next = next;
        }
        if ((prev_out1 = term.out1) != null) {
            prev_out1.next = next;
        }
        if ((prev_branch = term.branchOut) != null) {
            prev_branch.failNext = next;
        }
    }

    protected void startNewBranch() throws PatternSyntaxException {
        Term tmp = this.in.next;
        Branch b = new Branch();
        this.in.next = b;
        b.next = tmp;
        b.in = null;
        b.out = null;
        b.out1 = null;
        b.branchOut = b;
        this.current = b;
    }

    private static final Term makeGreedyStar(int[] vars, Term term, Vector iterators) throws PatternSyntaxException {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.next = term.in;
                term.out.next = b;
                b.in = b;
                b.out = null;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        Iterator i = new Iterator(term, 0, -1, iterators);
        return i;
    }

    private static final Term makeLazyStar(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.failNext = term.in;
                term.out.next = b;
                b.in = b;
                b.out = b;
                b.out1 = null;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        b.failNext = term;
        term.next = b;
        b.in = b;
        b.out = b;
        b.out1 = null;
        b.branchOut = null;
        return b;
    }

    private static final Term makeGreedyPlus(int[] vars, Term term, Vector iterators) throws PatternSyntaxException {
        switch (term.type) {
            case 15: 
            case 43: {
                Branch b = new Branch();
                b.next = term.in;
                term.out.next = b;
                b.in = term.in;
                b.out = null;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        return new Iterator(term, 1, -1, iterators);
    }

    private static final Term makeLazyPlus(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                term.out.next = b;
                b.failNext = term.in;
                b.in = term.in;
                b.out = b;
                b.out1 = null;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        term.next = b;
        b.failNext = term;
        b.in = term;
        b.out = b;
        b.out1 = null;
        b.branchOut = null;
        return b;
    }

    private static final Term makeGreedyQMark(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.next = term.in;
                b.in = b;
                b.out = term.out;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        Branch b = new Branch();
        b.next = term;
        b.in = b;
        b.out = term;
        b.out1 = null;
        b.branchOut = b;
        return b;
    }

    private static final Term makeLazyQMark(int[] vars, Term term) {
        switch (term.type) {
            case 15: {
                Branch b = new Branch();
                b.failNext = term.in;
                b.in = b;
                b.out = b;
                b.out1 = term.out;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        b.failNext = term;
        b.in = b;
        b.out = b;
        b.out1 = term;
        b.branchOut = null;
        return b;
    }

    private static final Term makeGreedyLimits(int[] vars, Term term, int[] limits, Vector iterators) throws PatternSyntaxException {
        int m = limits[0];
        int n = limits[1];
        switch (term.type) {
            case 15: {
                int n2 = vars[1];
                vars[1] = n2 + 1;
                int cntreg = n2;
                Term reset = new Term(29);
                reset.cntreg = cntreg;
                Term b = new Term(32);
                Term inc = new Term(28);
                inc.cntreg = cntreg;
                reset.next = b;
                if (n >= 0) {
                    Term lt = new Term(30);
                    lt.cntreg = cntreg;
                    lt.maxCount = n;
                    b.next = lt;
                    lt.next = term.in;
                } else {
                    b.next = term.in;
                }
                term.out.next = inc;
                inc.next = b;
                if (m >= 0) {
                    Term gt = new Term(31);
                    gt.cntreg = cntreg;
                    gt.maxCount = m;
                    b.failNext = gt;
                    reset.in = reset;
                    reset.out = gt;
                    reset.out1 = null;
                    reset.branchOut = null;
                } else {
                    reset.in = reset;
                    reset.out = null;
                    reset.out1 = null;
                    reset.branchOut = b;
                }
                return reset;
            }
        }
        return new Iterator(term, limits[0], limits[1], iterators);
    }

    private static final Term makeLazyLimits(int[] vars, Term term, int[] limits) {
        int m = limits[0];
        int n = limits[1];
        switch (term.type) {
            case 15: {
                int n2 = vars[1];
                vars[1] = n2 + 1;
                int cntreg = n2;
                Term reset = new Term(29);
                reset.cntreg = cntreg;
                Term b = new Term(32);
                Term inc = new Term(28);
                inc.cntreg = cntreg;
                reset.next = b;
                if (n >= 0) {
                    Term lt = new Term(30);
                    lt.cntreg = cntreg;
                    lt.maxCount = n;
                    b.failNext = lt;
                    lt.next = term.in;
                } else {
                    b.failNext = term.in;
                }
                term.out.next = inc;
                inc.next = b;
                if (m >= 0) {
                    Term gt = new Term(31);
                    gt.cntreg = cntreg;
                    gt.maxCount = m;
                    b.next = gt;
                    reset.in = reset;
                    reset.out = gt;
                    reset.out1 = null;
                    reset.branchOut = null;
                    return reset;
                }
                reset.in = reset;
                reset.out = b;
                reset.out1 = null;
                reset.branchOut = null;
                return reset;
            }
        }
        Term reset = new Term(24);
        Branch b = new Branch(33);
        Term inc = new Term(25);
        reset.next = b;
        if (n >= 0) {
            Term lt = new Term(27);
            lt.maxCount = n;
            b.failNext = lt;
            lt.next = term;
            term.next = inc;
            inc.next = b;
        } else {
            b.next = term;
            term.next = inc;
            inc.next = term;
        }
        if (m >= 0) {
            Term gt = new Term(26);
            gt.maxCount = m;
            b.next = gt;
            reset.in = reset;
            reset.out = gt;
            reset.out1 = null;
            reset.branchOut = null;
            return reset;
        }
        reset.in = reset;
        reset.out = b;
        reset.out1 = null;
        reset.branchOut = null;
        return reset;
    }

    private final int parseTerm(char[] data, int i, int out, Term term, int flags) throws PatternSyntaxException {
        int c = data[i++];
        boolean inv = false;
        switch (c) {
            case 91: {
                return CharacterClass.parseClass(data, i, out, term, (flags & 1) > 0, (flags & 8) > 0, (flags & 0x10) > 0, (flags & 0x20) > 0);
            }
            case 46: {
                term.type = (flags & 4) > 0 ? 4 : 5;
                break;
            }
            case 36: {
                term.type = (flags & 2) > 0 ? 22 : 20;
                break;
            }
            case 94: {
                term.type = (flags & 2) > 0 ? 21 : 18;
                break;
            }
            case 92: {
                if (i >= out) {
                    throw new PatternSyntaxException("Escape without a character");
                }
                c = data[i++];
                switch (c) {
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        c = (char)((CharacterClass.toHexDigit(data[i++]) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                        break;
                    }
                    case 118: {
                        c = (char)((CharacterClass.toHexDigit(data[i++]) << 24) + (CharacterClass.toHexDigit(data[i++]) << 16) + (CharacterClass.toHexDigit(data[i++]) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                        break;
                    }
                    case 120: {
                        int hex = 0;
                        char d = data[i++];
                        if (d == '{') {
                            while ((d = data[i++]) != '}') {
                                if ((hex = (hex << 4) + CharacterClass.toHexDigit(d)) <= 65535) continue;
                                throw new PatternSyntaxException("\\x{<out of range>}");
                            }
                        } else {
                            hex = (CharacterClass.toHexDigit(d) << 4) + CharacterClass.toHexDigit(data[i++]);
                        }
                        c = (char)hex;
                        break;
                    }
                    case 48: 
                    case 111: {
                        char d;
                        int oct = 0;
                        while ((d = data[i++]) >= '0' && d <= '7') {
                            oct *= 8;
                            if ((oct += d - 48) <= 65535) continue;
                            break;
                        }
                        c = (char)oct;
                        break;
                    }
                    case 109: {
                        char d;
                        int dec = 0;
                        while ((d = data[i++]) >= '0' && d <= '9') {
                            dec *= 10;
                            if ((dec += d - 48) <= 65535) continue;
                            break;
                        }
                        c = (char)dec;
                        break;
                    }
                    case 99: {
                        c = (char)(data[i++] & 0x1F);
                        break;
                    }
                    case 68: {
                        inv = true;
                    }
                    case 100: {
                        CharacterClass.makeDigit(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 83: {
                        inv = true;
                    }
                    case 115: {
                        CharacterClass.makeSpace(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 87: {
                        inv = true;
                    }
                    case 119: {
                        CharacterClass.makeWordChar(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 66: {
                        inv = true;
                    }
                    case 98: {
                        CharacterClass.makeWordBoundary(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 60: {
                        CharacterClass.makeWordStart(term, (flags & 0x10) > 0);
                        return i;
                    }
                    case 62: {
                        CharacterClass.makeWordEnd(term, (flags & 0x10) > 0);
                        return i;
                    }
                    case 65: {
                        term.type = 18;
                        return i;
                    }
                    case 90: {
                        term.type = 20;
                        return i;
                    }
                    case 122: {
                        term.type = 19;
                        return i;
                    }
                    case 71: {
                        term.type = 23;
                        return i;
                    }
                    case 80: {
                        inv = true;
                    }
                    case 112: {
                        i = CharacterClass.parseName(data, i, out, term, inv, (flags & 8) > 0);
                        return i;
                    }
                    default: {
                        if (c < 49 || c > 57) break;
                        int n = c - 48;
                        while (i < out && (c = data[i]) >= 48 && c <= 57) {
                            n = n * 10 + c - 48;
                            ++i;
                        }
                        term.type = (flags & 1) > 0 ? 7 : 6;
                        term.memreg = n;
                        return i;
                    }
                }
                term.type = 0;
                term.c = (char)c;
                break;
            }
            default: {
                if ((flags & 1) == 0) {
                    term.type = 0;
                    term.c = c;
                    break;
                }
                CharacterClass.makeICase(term, (char)c);
            }
        }
        return i;
    }

    protected static final int parseLimits(int i, int end, char[] data, int[] limits) throws PatternSyntaxException {
        if (limits.length != 3) {
            throw new IllegalArgumentException("maxTimess.length=" + limits.length + ", should be 2");
        }
        limits[2] = 1;
        int ind = 0;
        int v = 0;
        block5: while (i < end) {
            char c = data[i++];
            switch (c) {
                case ' ': {
                    continue block5;
                }
                case ',': {
                    if (ind > 0) {
                        throw new PatternSyntaxException("illegal construction: {.. , , ..}");
                    }
                    limits[ind++] = v;
                    v = -1;
                    continue block5;
                }
                case '}': {
                    limits[ind] = v;
                    if (ind == 0) {
                        limits[1] = v;
                    }
                    return i;
                }
            }
            if (c > '9' || c < '0') {
                limits[2] = 2;
                return i;
            }
            if (v < 0) {
                v = 0;
            }
            v = v * 10 + (c - 48);
        }
        throw new PatternSyntaxException("malformed quantifier");
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append(this.instanceNum);
        b.append(": ");
        if (this.inverse) {
            b.append('^');
        }
        switch (this.type) {
            case 17: {
                b.append("[]");
                b.append(" , ");
                break;
            }
            case 0: {
                b.append(CharacterClass.stringValue(this.c));
                b.append(" , ");
                break;
            }
            case 4: {
                b.append("dotall, ");
                break;
            }
            case 5: {
                b.append("dot-eols, ");
                break;
            }
            case 1: {
                b.append('[');
                b.append(CharacterClass.stringValue0(this.bitset));
                b.append(']');
                b.append(" , weight=");
                b.append(this.weight);
                b.append(" , ");
                break;
            }
            case 2: {
                b.append('[');
                b.append(CharacterClass.stringValue2(this.bitset2));
                b.append(']');
                b.append(" , weight=");
                b.append(this.weight);
                b.append(" , ");
                break;
            }
            case 18: {
                b.append("abs.start");
                break;
            }
            case 19: {
                b.append("abs.end");
                break;
            }
            case 20: {
                b.append("abs.end-eol");
                break;
            }
            case 21: {
                b.append("line start");
                break;
            }
            case 22: {
                b.append("line end");
                break;
            }
            case 23: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("BOUNDARY");
                break;
            }
            case 11: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("BOUNDARY");
                break;
            }
            case 13: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("UBOUNDARY");
                break;
            }
            case 12: {
                b.append("DIRECTION");
                break;
            }
            case 14: {
                b.append("UDIRECTION");
                break;
            }
            case 8: {
                b.append(">>>{");
                b.append(this.target);
                b.append("}, <<");
                b.append(this.distance);
                if (this.eat) {
                    b.append(",eat");
                }
                b.append(", ");
                break;
            }
            case 45: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",0,inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 46: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",");
                b.append(this.minCount);
                b.append(",inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 47: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",");
                b.append(this.minCount);
                b.append(",");
                b.append(this.maxCount);
                b.append("}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 48: {
                b.append("rpt{$");
                b.append(this.memreg);
                b.append(',');
                b.append(this.minCount);
                b.append(",inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 49: {
                b.append("rpt{$");
                b.append(this.memreg);
                b.append(',');
                b.append(this.minCount);
                b.append(',');
                b.append(this.maxCount);
                b.append("}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 50: {
                b.append("back(0)");
                break;
            }
            case 51: {
                b.append("back(");
                b.append(this.minCount);
                b.append(")");
                break;
            }
            case 54: {
                b.append("back");
                b.append("_$");
                b.append(this.memreg);
                b.append("(");
                b.append(this.minCount);
                b.append(")");
                break;
            }
            case 15: {
                b.append('(');
                if (this.memreg > 0) {
                    b.append(this.memreg);
                }
                b.append('-');
                b.append(" , ");
                break;
            }
            case 16: {
                b.append('-');
                if (this.memreg > 0) {
                    b.append(this.memreg);
                }
                b.append(')');
                b.append(" , ");
                break;
            }
            case 35: {
                b.append('(');
                b.append("=");
                b.append(this.lookaheadId);
                b.append(" , ");
                break;
            }
            case 36: {
                b.append('=');
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 37: {
                b.append("(!");
                b.append(this.lookaheadId);
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 38: {
                b.append('!');
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 39: {
                b.append('(');
                b.append("<=");
                b.append(this.lookaheadId);
                b.append(" , dist=");
                b.append(this.distance);
                b.append(" , ");
                break;
            }
            case 40: {
                b.append("<=");
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 41: {
                b.append("(<!");
                b.append(this.lookaheadId);
                b.append(" , dist=");
                b.append(this.distance);
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 42: {
                b.append("<!");
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case 55: {
                b.append("(reg");
                b.append(this.memreg);
                b.append("?)");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 56: {
                b.append("(cond");
                b.append(this.lookaheadId);
                b.append(((Lookahead)this).isPositive ? (char)'=' : '!');
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 57: {
                b.append("cond");
                b.append(this.lookaheadId);
                b.append(")");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case 6: {
                b.append("$");
                b.append(this.memreg);
                b.append(", ");
                break;
            }
            case 10: {
                b.append("END");
                break;
            }
            case 34: {
                b.append("(aux1)");
            }
            case 33: {
                b.append("(cnt)");
            }
            case 32: {
                b.append("=>");
                if (this.failNext != null) {
                    b.append(this.failNext.instanceNum);
                } else {
                    b.append("null");
                }
                b.append(" , ");
                break;
            }
            default: {
                b.append('[');
                switch (this.type) {
                    case 24: {
                        b.append("cnt=0");
                        break;
                    }
                    case 25: {
                        b.append("cnt++");
                        break;
                    }
                    case 26: {
                        b.append("cnt>=" + this.maxCount);
                        break;
                    }
                    case 27: {
                        b.append("->cnt<" + this.maxCount);
                        break;
                    }
                    case 28: {
                        b.append("M(" + this.memreg + ")->,Cr(" + this.cntreg + ")->,Cr(" + this.cntreg + ")++");
                        break;
                    }
                    case 29: {
                        b.append("Cr(" + this.cntreg + ")=0");
                        break;
                    }
                    case 30: {
                        b.append("Cr(" + this.cntreg + ")<" + this.maxCount);
                        break;
                    }
                    case 31: {
                        b.append("Cr(" + this.cntreg + ")>=" + this.maxCount);
                        break;
                    }
                    default: {
                        b.append("unknown type: " + this.type);
                    }
                }
                b.append("] , ");
            }
        }
        if (this.next != null) {
            b.append("->");
            b.append(this.next.instanceNum);
            b.append(", ");
        }
        return b.toString();
    }

    public String toStringAll() {
        return this.toStringAll(new Vector());
    }

    public String toStringAll(Vector v) {
        v.addElement(new Integer(this.instanceNum));
        String s = this.toString();
        if (this.next != null && !v.contains(new Integer(this.next.instanceNum))) {
            s = s + "\r\n";
            s = s + this.next.toStringAll(v);
        }
        if (this.failNext != null && !v.contains(new Integer(this.failNext.instanceNum))) {
            s = s + "\r\n";
            s = s + this.failNext.toStringAll(v);
        }
        return s;
    }
}

