/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.Map;

public class TransactionEventsConfig
extends BaseConfig {
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.transaction_events.";
    public static final String MAX_SAMPLES_STORED = "max_samples_stored";
    private static final String COLLECT_ANALYTICS_EVENTS = "collect_analytics_events";
    private static final String ENABLED = "enabled";
    private static final String TARGET_SAMPLES_STORED = "target_samples_stored";
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_MAX_SAMPLES_STORED = 2000;
    public static final int DEFAULT_TARGET_SAMPLES_STORED = 10;
    private final boolean enabled;
    private final int maxSamplesStored = this.getProperty("max_samples_stored", 2000);
    private final int targetSamplesStored;

    public TransactionEventsConfig(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.enabled = this.maxSamplesStored > 0 & this.initEnabled();
        this.targetSamplesStored = this.getProperty(TARGET_SAMPLES_STORED, 10);
    }

    private boolean initEnabled() {
        return this.getProperty(ENABLED, true) != false && this.getProperty(COLLECT_ANALYTICS_EVENTS, true) != false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public int getTargetSamplesStored() {
        return this.targetSamplesStored;
    }
}

