/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import java.util.Map;
import java.util.logging.Level;

public class DistributedTracingConfig
extends BaseConfig {
    private static final boolean DEFAULT_DISTRIBUTED_TRACING = false;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.distributed_tracing.";
    public static final String ENABLED = "enabled";
    public static final String TRUSTED_ACCOUNT_KEY = "trusted_account_key";
    public static final String ACCOUNT_ID = "account_id";
    public static final String PRIMARY_APPLICATION_ID = "primary_application_id";
    public static final String DISTRIBUTED_TRACING_ENABLED = "newrelic.config.distributed_tracing.enabled";
    public static final String ENABLED_ENV_KEY = "NEW_RELIC_DISTRIBUTED_TRACING_ENABLED";
    private final boolean enabled;
    private final String trustedAccountKey;
    private final String accountId;
    private final String primaryApplicationId;

    DistributedTracingConfig(Map<String, Object> props, boolean autoAppNameEnabled) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.enabled = this.initEnabled(autoAppNameEnabled);
        this.trustedAccountKey = (String)this.getProperty(TRUSTED_ACCOUNT_KEY);
        this.accountId = (String)this.getProperty(ACCOUNT_ID);
        this.primaryApplicationId = (String)this.getProperty(PRIMARY_APPLICATION_ID);
    }

    private boolean initEnabled(boolean autoAppNameEnabled) {
        Boolean configEnabled = this.getProperty(ENABLED, false);
        if (autoAppNameEnabled && configEnabled.booleanValue()) {
            Agent.LOG.log(Level.WARNING, "Disabled distributed_tracing. It is currently incompatible with auto_app_naming.");
            return false;
        }
        return configEnabled;
    }

    public String getTrustedAccountKey() {
        return this.trustedAccountKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPrimaryApplicationId() {
        return this.primaryApplicationId;
    }

    public String getAccountId() {
        return this.accountId;
    }
}

